/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.security.ISecurityCard;
import com.raoulvdberge.refinedstorage.api.network.security.ISecurityCardContainer;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.security.SecurityCard;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.item.validator.ItemValidatorBasic;
import com.raoulvdberge.refinedstorage.inventory.listener.ListenerNetworkNode;
import com.raoulvdberge.refinedstorage.item.ItemSecurityCard;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class NetworkNodeSecurityManager
extends NetworkNode
implements ISecurityCardContainer {
    public static final String ID = "security_manager";
    private final List<ISecurityCard> cards = new ArrayList<ISecurityCard>();
    private ISecurityCard globalCard;
    private final ItemHandlerBase cardsInv = new ItemHandlerBase(18, new ListenerNetworkNode(this), new Predicate[]{new ItemValidatorBasic(RSItems.SECURITY_CARD)}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (!NetworkNodeSecurityManager.this.world.field_72995_K) {
                NetworkNodeSecurityManager.this.invalidate();
            }
            if (NetworkNodeSecurityManager.this.network != null) {
                NetworkNodeSecurityManager.this.network.getSecurityManager().invalidate();
            }
        }
    };
    private final ItemHandlerBase editCard = new ItemHandlerBase(1, new ListenerNetworkNode(this), new ItemValidatorBasic(RSItems.SECURITY_CARD));

    public NetworkNodeSecurityManager(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        int usage = RS.INSTANCE.config.securityManagerUsage;
        for (int i = 0; i < this.cardsInv.getSlots(); ++i) {
            if (this.cardsInv.getStackInSlot(i).func_190926_b()) continue;
            usage += RS.INSTANCE.config.securityManagerPerSecurityCardUsage;
        }
        return usage;
    }

    @Override
    public void updateNetworkNode() {
        super.updateNetworkNode();
        if (this.ticks == 1) {
            this.invalidate();
        }
    }

    private void invalidate() {
        this.cards.clear();
        this.globalCard = null;
        for (int i = 0; i < this.cardsInv.getSlots(); ++i) {
            ItemStack stack = this.cardsInv.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            UUID uuid = ItemSecurityCard.getOwner(stack);
            if (uuid == null) {
                this.globalCard = this.createCard(stack, null);
                continue;
            }
            this.cards.add(this.createCard(stack, uuid));
        }
    }

    private ISecurityCard createCard(ItemStack stack, @Nullable UUID uuid) {
        SecurityCard card = new SecurityCard(uuid);
        for (Permission permission : Permission.values()) {
            card.getPermissions().put(permission, ItemSecurityCard.hasPermission(stack, permission));
        }
        return card;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.cardsInv, 0, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.editCard, 1, tag);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.cardsInv, 0, tag);
        StackUtils.writeItems((IItemHandler)this.editCard, 1, tag);
        return tag;
    }

    @Override
    public void onConnectedStateChange(INetwork network, boolean state) {
        super.onConnectedStateChange(network, state);
        network.getSecurityManager().invalidate();
    }

    public ItemHandlerBase getCardsItems() {
        return this.cardsInv;
    }

    public ItemHandlerBase getEditCard() {
        return this.editCard;
    }

    public void updatePermission(Permission permission, boolean state) {
        ItemStack card = this.getEditCard().getStackInSlot(0);
        if (!card.func_190926_b()) {
            ItemSecurityCard.setPermission(card, permission, state);
        }
    }

    @Override
    public List<ISecurityCard> getCards() {
        return this.cards;
    }

    @Override
    @Nullable
    public ISecurityCard getGlobalCard() {
        return this.globalCard;
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.cardsInv, this.editCard});
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }
}

